% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/03_similarity_searches.R
\name{make_bidirectional}
\alias{make_bidirectional}
\title{Create a data frame of bidirectional comparisons from unidirectional comparisons}
\usage{
make_bidirectional(compare)
}
\arguments{
\item{compare}{A 2-column data frame with name(s) of target species in
column 1, and name(s) of outgroup species in column 2.}
}
\value{
A 2-column data frame as in \strong{compare}, but extended to
contain bidirectional comparisons. If the data frame in \strong{compare} has
N rows, the output data frame should contain 2N rows.
}
\description{
Create a data frame of bidirectional comparisons from unidirectional comparisons
}
\examples{
spp_outgroup <- data.frame(species = "spA", outgroup = "spB")
comp_bi <- make_bidirectional(spp_outgroup)
comp_bi
}
