% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tTest.R
\name{tTest}
\alias{tTest}
\title{student's t-test on B-score}
\usage{
tTest(mtx, n_treat, n_cont)
}
\arguments{
\item{mtx}{b-score matrix.}

\item{n_treat}{number of treatment plates}

\item{n_cont}{number of control plates}
}
\value{
A list containing student's t-test for each master plate
\itemize{
  \item pvalue: p-value of the t-test
  \item Treat_Cont: difference in bscore: treatment - control
  \item p_adj: BH adjusted p-value
}
}
\description{
Select hits by student's t-test using B-score from treatment and control plates.
}
\examples{
data(example_dt)
bscore_res <- sapply(unique(example_dt$MASTER_PLATE), bScore,
  example_dt, control = "control", treatment = "treatment", simplify = FALSE)
tTest(bscore_res$P001, 3, 3)
}
\references{
Birmingham, A. et al. Statistical methods for analysis of high-throughput RNA interference screens. Nat Methods 6, 569-575 (2009).
}
