% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_synergy_score.R
\name{CorrectBaseLine}
\alias{CorrectBaseLine}
\title{Base Line Correction for Drug Combination Matrix}
\usage{
CorrectBaseLine(response, method = c("non", "part", "all"))
}
\arguments{
\item{response}{A drug combination dose-response matrix. It's column name
and row name are representing the concentrations of drug added to column
and row, respectively. The values in matrix indicate the inhibition rate to
cell growth.}

\item{method}{A character value. It indicates the method used for
baseline correction. Available values are:
\itemize{
  \item \strong{non} No baseline correction.
  \item \strong{part} Adjust only the negative values in the matrix.
  \item \strong{all} Adjust all values in the matrix.
}}
}
\value{
A matrix which base line have been adjusted.
}
\description{
\code{CorrectBaseLine} adjusts the base line of drug combination
dose-response matrix to make it closer to 0.
}
\examples{
data("mathews_screening_data")
data <- ReshapeData(mathews_screening_data)
response <- data$response[data$response$block_id == 1, ]
adjusted <- CorrectBaseLine(response, method = "part")
}
\author{
\itemize{
    \item Shuyu Zheng \email{shuyu.zheng@helsinki.fi}
    \item Jing Tang \email{jing.tang@helsinki.fi}
 }
}
