% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eventDetection.R
\name{rtDetect}
\alias{rtDetect}
\title{Detecting retrotranscript insertion in nuclear genomes.}
\usage{
rtDetect(gr, genes, maxgap = 100, minscore = 0.4)
}
\arguments{
\item{gr}{A GRanges object}

\item{genes}{TxDb object of genes. hg19 and hg38 are supported in the current version.}

\item{maxgap}{The maxium distance allowed on the reference genome between the paired exon boundries.}

\item{minscore}{The minimum proportion of intronic deletions of a transcript should be identified.}
}
\value{
A GRangesList object, named insSite and rt, reporting breakpoints supporting insert sites and 
retroposed transcripts respectively. 'exon' and 'txs' in the metadata columns report exon_id and transcript_name from the 'genes' object.
}
\description{
Detecting retrotranscript insertion in nuclear genomes.
}
\details{
This function searches for retroposed transcripts by identifying breakpoints supporting 
intronic deletions and fusions between exons and remote loci.
Only BND notations are supported at the current stage.
}
\examples{
library(TxDb.Hsapiens.UCSC.hg19.knownGene)
genes <- TxDb.Hsapiens.UCSC.hg19.knownGene
vcf.file <- system.file("extdata", "diploidSV.vcf",
                         package = "svaRetro")
vcf <- VariantAnnotation::readVcf(vcf.file, "hg19")
gr <- breakpointRanges(vcf, nominalPosition=TRUE)
rt <- rtDetect(gr, genes, maxgap=30, minscore=0.6)
}
