% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survClust.R, R/zzz.R
\docType{package}
\name{survClust}
\alias{survClust-package}
\alias{survClust}
\title{perform supervised clustering for a particular \code{k}}
\usage{
survClust(combine.dist, survdat, k, cmd.k = NULL)
}
\arguments{
\item{combine.dist}{integrated weighted distance matrix from \code{combineDist}}

\item{survdat}{A nx2 matrix consisting of survival data with \code{n} samples and first column as time and second column as events, with samples as rownames}

\item{k}{choice of \code{k} to perform clustering on samples}

\item{cmd.k}{number of dimensions used by \code{cmdscale} to perform clustering on samples. Defaults is \code{n-1}}
}
\value{
\itemize{
\item{fit} { returns a list , \code{fit} consisting of all clustering samples as in \code{kmeans}
\code{fit.lr}, computed logrank statistic between \code{k} clusters}
}
}
\description{
\code{survClust} function performs supervised clustering on a \code{combineDist} output for a particular \code{k}.
It uses all \code{n-1} dimensions for clustering.

survClust is an outcome weighted integrative clustering algorithm used to classify multi-omic samples on their available time to event information.
}
\examples{
library(survClust)
dd <- getDist(datasets = simdat, survdat = simsurvdat)
cc <- combineDist(dd)
survclust_fit <- survClust(combine.dist = cc, survdat = simsurvdat, k = 3)

}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/arorarshi/survClust}
  \item Report bugs at \url{https://support.bioconductor.org/t/survClust}
}

}
\author{
Arshi Arora

\strong{Maintainer}: Arshi Arora \email{arshiaurora@gmail.com} (\href{https://orcid.org/0000-0002-4040-1787}{ORCID})

}
