% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getStats.R
\name{getStats}
\alias{getStats}
\title{Compute fit statistics after cross validation via \code{cv_survclust}}
\usage{
getStats(cv.fit, kk = 8, cvr = 50)
}
\arguments{
\item{cv.fit}{output from \code{cv_survclust} object}

\item{kk}{number of \code{k} clusters on which \code{cv_survclust} was run, default is \code{8}}

\item{cvr}{round of cross-validation on which \code{cv_survclust}  was run, default is \code{50}}
}
\value{
A list of the following
\itemize{
\item{lr} {log rank statistic}
\item{spwss} {standardized pooled within sum of squares}
\item{bad.sol} {number of solutions for each \code{kk} that have cluster class \code{<5} samples}
}
}
\description{
Compute fit statistics after cross validation via \code{cv_survclust}
}
\details{
\code{getStats} calculates Logrank statistic and standardized pooled within sum of squares (SPWSS) across
cross-validated labels. Visualize it via \code{plotStats}
}
\examples{
library(survClust)
ss_stats <- getStats(uvm_survClust_cv.fit, kk=7, cvr=10)

}
\author{
Arshi Arora
}
