% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_phobius.R
\name{run_phobius}
\alias{run_phobius}
\title{Create a data frame with the membrane locations of each amino acid in a
protein using Phobius}
\usage{
run_phobius(AA_seq, fasta_file_name)
}
\arguments{
\item{AA_seq}{A data frame outputted by the get_pairs function
containing the gene names, transcript IDs, APPRIS annotations, and
protein sequences for each transcript.}

\item{fasta_file_name}{Path to fasta file containing amino acid sequences}
}
\value{
A data frame containing each transcript ID and the corresponding
membrane location for each amino acid in its sequence formatted as a string
}
\description{
This function creates a data frame with columns containing transcript
IDs and corresponding output from Phobius. The Phobius output includes a
location for each amino acid, with O representing extracellular, M
representing transmembrane, S representing signal, and i representing
intracellular.
}
\note{
In order for this function to work, there needs to be a .fasta file
containing the amino acid sequences for each transcript called "AA.fasta"
saved to the working directory. Additionally, the file saves a copy of the
returned data frame in csv format to the working directory.
}
\examples{
tmhmm_folder_name <- "~/TMHMM2.0c"
if (check_tmhmm_install(tmhmm_folder_name)) {
    currwd <- getwd()
    AA_seq <- get_pairs(system.file("extdata", "crb1_example.csv",
        package = "surfaltr"
    ), TRUE, "mouse", TRUE)
    topo <- run_phobius(AA_seq, paste(getwd(), "/AA.fasta", sep = ""))
    setwd(currwd)
}
}
