% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process_tmhmm.R
\name{process_tmhmm}
\alias{process_tmhmm}
\title{Create a data frame with the membrane locations of each amino acid in a
sequence}
\usage{
process_tmhmm(topo, AA_seq)
}
\arguments{
\item{topo}{A data frame containing each transcript ID and the corresponding
membrane location for each amino acid in its sequence formatted as a string.}

\item{AA_seq}{A data frame containing the gene names, transcript IDs, APPRIS
annotations, and protein sequences for each transcript.}
}
\value{
A data frame containing the overall length and individual lengths of
each section of the surface protein corresponding to a certain transcript.
}
\description{
This function creates a data frame with columns containing transcript
IDs and corresponding output from tmhmm. The tmhmm output includes a location
for each amino acid, with O and o representing extracellular, M representing
transmembrane, and i representing intracellular. The data frame includes
columns with the transcript ID, membrane location, gene name, starting amino
acid, and ending amino acid for a certain transcript. The first row for each
transcript contains the overall length of the amino acid sequence.
}
