% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/merge_trans.R
\name{merge_trans}
\alias{merge_trans}
\title{Associate Inputted Transcripts with Corresponding Primary Transcripts}
\usage{
merge_trans(princ, final_trans, if_aa)
}
\arguments{
\item{princ}{Data frame containing all primary transcripts and relevant
gene information for an organism}

\item{final_trans}{Data frame containing cleaned and formatted input data}

\item{if_aa}{Boolean value indicating if the input file contains
amino acid sequences with TRUE indicating that sequences are present and
FALSE indicating that only IDs are present}
}
\value{
A data frame containing gene names, transcript IDs, and APPRIS
annotations for all inputted data and its corresponding primary transcripts.
If sequences were provided, the data frame will also contain
the amino acid sequences. If only IDs were provided, the data frame will
also contain the UniProt Swissprot ID, UniProt Swissprot isoform ID, and
UniProt TREMBL ID for both the inputted data and the primary transcripts.
}
\description{
This function matches each inputted transcript with its corresponding
primary transcripts and returns a data frame containing the gene name,
transcript ID and APPRIS annotation for each.
}
