% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph_from_ids.R
\name{graph_from_ids}
\alias{graph_from_ids}
\title{Create a plot showing membrane locations of each protein based on
transcript IDs}
\usage{
graph_from_ids(data_file, organism = "human", rank = "length",
n_prts = 20, mode = "phobius", size_txt = 2, space_left = -400, temp = FALSE,
tmhmm_folder_name = NULL)
}
\arguments{
\item{data_file}{Path to the input file}

\item{organism}{String indicating if the transcripts are from a human or
a mouse}

\item{rank}{String indicating which method to use to rank proteins in graphicl
output. Options include "Length", "TM", and "Combo".}

\item{n_prts}{Integer value indicating the number of genes that should be
displayed on the graphical output. Default value is 20.}

\item{mode}{String detailing whether TMHMM or Phobius should be used to
predict transmembrane regions. Input values include "phobius" or "tmhmm".}

\item{size_txt}{Integer value specifying the size of the row labels. Default
size is 2.}

\item{space_left}{Integer value specifying how far left the graph should
extend.}

\item{temp}{Boolean indicating if the fasta file should be deleted after the
function finishes running or not. Recommended to always be set to FALSE.}

\item{tmhmm_folder_name}{Full path to folder containing installed TMHMM 2.0
software. This value should end in TMHMM2.0c and needs to be provided if
the mode used is TMHMM.}
}
\value{
A ggplot figure showing the protein locations for each part of the
surface protein for each alternative and primary transcripts.
}
\description{
This function creates a ggplot figure showing the differences in membrane
location and length between primary and alternative transcripts from the
same gene. This process is performed based on input data
containing the gene names and transcript IDs of the proteins in question.
Transcripts derived from the same gene are grouped together
to facilitate easy interpretation. The y axis lists the gene name and
transcript ID for each transcript and the x axis lists the length in
amino acids. Each fill color corresponds to a membrane location and either
principal or alternative isoform.
}
\examples{
tmhmm_folder_name <- "~/TMHMM2.0c"
if (check_tmhmm_install(tmhmm_folder_name)) {
    graph_from_ids(
        system.file("extdata", "hpa_example.csv", package = "surfaltr"),
        "human", "length", 1, "tmhmm", 5, -300, TRUE
    )
}
}
