% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_phobius.R
\name{get_phobius}
\alias{get_phobius}
\alias{get_phobius.default}
\alias{get_phobius.character}
\alias{get_phobius.data.frame}
\alias{get_phobius.list}
\title{Query Phobius web server.}
\source{
\url{https://phobius.sbc.su.se/}
}
\usage{
get_phobius(data, ...)

\method{get_phobius}{character}(data, progress = FALSE, ...)

\method{get_phobius}{data.frame}(data, sequence, id, ...)

\method{get_phobius}{list}(data, ...)

\method{get_phobius}{default}(data = NULL, sequence, id, ...)
}
\arguments{
\item{data}{A data frame with protein amino acid sequences as strings in one 
column and corresponding id's in another. Alternatively a path to a .fasta 
file with protein sequences. Alternatively a list with elements of class 
"SeqFastaAA" resulting from \code{\link[seqinr]{read.fasta}} call. 
Should be left blank if vectors are provided to sequence and id arguments.}

\item{...}{currently no additional arguments are accepted apart the ones 
documented bellow.}

\item{progress}{Boolean, whether to show the progress bar, at default set to 
FALSE.}

\item{sequence}{A vector of strings representing protein amino acid sequences, 
or the appropriate column name if a data.frame is supplied to data argument. 
If .fasta file path, or list with elements of class "SeqFastaAA" provided to 
data, this should be left blank.}

\item{id}{A vector of strings representing protein identifiers, or the 
appropriate column name if a data.frame is supplied to data argument. If 
.fasta file path, or list with elements of class "SeqFastaAA" provided to 
data, this should be left blank.}
}
\value{
A data frame with columns:
\describe{
\item{Name}{Character, name of the submitted sequence.}
\item{tm}{Integer, the number of predicted transmembrane segments.}
\item{sp}{Character, Y/0 indicator if a signal peptide was predicted or not.}
\item{prediction}{Character string, predicted topology of the protein.}
\item{cut_site}{Integer, first amino acid after removal of the signal peptide}
\item{is.phobius}{Logical, did Phobius predict the presence of a signal
 peptide}}
}
\description{
Phobius web server is a combined transmembrane topology and signal peptide 
(N-sp) predictor. Currently only "normal prediction" of signal peptides is 
supported by the function.
}
\details{
The topology (prediction column of the result) is given as the position of 
the transmembrane helices separated by 'i' if the loop is on the cytoplasmic 
or 'o' if it is on the non-cytoplasmic side. A signal peptide is given by the 
position of its h-region separated by a n and a c, and the position of the 
last amino acid in the signal peptide and the first of the mature protein 
separated by a /.
}
\note{
This function creates temporary files in the working directory.
}
\references{
Kall O. Krogh A. Sonnhammer E. L. L. (2004) A Combined 
Transmembrane Topology and Signal Peptide Prediction Method. Journal 
of Molecular Biology 338(5): 1027-1036
}
