% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_tmhmm_install.R
\name{check_tmhmm_install}
\alias{check_tmhmm_install}
\title{Check to make sure TMHMM 2.0 is installed in the file path specified}
\usage{
check_tmhmm_install(tmhmm_folder_name)
}
\arguments{
\item{tmhmm_folder_name}{Full path to folder containing installed TMHMM 2.0
software. This value should end in TMHMM2.0c}
}
\value{
A Boolean stating if TMHMM is installed correctly, will be TRUE
if TMHMM 2.0 is located at the path specified and FALSE if it is not.
}
\description{
This function checks to make sure that TMHMM is installed correctly
at the file path specified by the user. If TMHMM is not installed correctly,
then the function will output an error message telling the user to check 
their installation.
}
\note{
This function also prints a helpful method providing tips on how
to fix the installation if TMHMM is not found at the folder path specified.
}
\examples{
tmhmm_folder_name <- "~/TMHMM2.0c"
install_correct <- check_tmhmm_install(tmhmm_folder_name)
}
