% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/align_org_prts.R
\name{align_org_prts}
\alias{align_org_prts}
\title{Get aligned amino acid sequences for gene transcripts from multiple organisms}
\usage{
align_org_prts(gene_names, hs_data_file, mm_data_file, if_aa = FALSE, 
temp = FALSE)
}
\arguments{
\item{gene_names}{Vector containing names of genes of interest
(e.g. c("Crb1", "Adgrl1"))}

\item{hs_data_file}{Path to the input file containing the human transcripts}

\item{mm_data_file}{Path to the input file containing the mouse transcripts}

\item{if_aa}{Boolean value indicating if the input file contains
amino acid sequence. TRUE indicates that sequences are present and
FALSE indicates that only IDs are present.}

\item{temp}{Boolean indicating if the fasta file should be saved to the
working directory or no}
}
\value{
Nothing is returned.
}
\description{
This function allows a user to specify genes of interest and subsequently
receive a pdf of all the corresponding aligned human and mouse amino acid 
sequences. In order for this to work, transcripts for the same genes 
from both organisms need to be provided in separate files.
}
\note{
Although the function returns nothing, it saves pdfs containing the
aligned sequences to the working directory under a file labeled with the
gene name. It's also important to note that although the gene names will
be standardized to be fully capitalized, this may not match with the case
of the gene name for some organisms.
}
\examples{
tmhmm_folder_name <- "~/TMHMM2.0c"
if (check_tmhmm_install(tmhmm_folder_name)) {align_org_prts( c("IGSF1"),
system.file("extdata", "hpa_example.csv", package = "surfaltr"),
system.file("extdata", "hpa_mouse_example.csv", 
package = "surfaltr"),
FALSE, TRUE)}
}
