% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simplify_signature.R
\name{simplify_signature}
\alias{simplify_signature}
\title{Function to simplify signature representation 
into interpretable labels for visualization purposes}
\usage{
simplify_signature(object, iupac)
}
\arguments{
\item{object}{an object of class \code{SuperSig}}

\item{iupac}{logical value indicating whether to use IUPAC labels
(iupac = \code{TRUE}) or not (iupac = \code{FALSE})}
}
\value{
\code{simplify_signature} returns a vector of
simplified features and their difference in mean
mean rates between exposed and unexposed (or
average rate if the factor is "age")
}
\description{
Take a signature representation from SuperSig
and group trinucleotides within each feature into
interpretable labels, with optional IUPAC labeling
from IUPAC_CODE_MAP in the Biostrings package
}
\examples{

head(example_dt) # use example data from package
input_dt <- make_matrix(example_dt) # convert to correct format
input_dt$IndVar <- c(1, 1, 1, 0, 0) # add IndVar column
supersig <- get_signature(data = input_dt, factor = "Smoking")
simplify_signature(object = supersig, iupac = FALSE)
simplify_signature(object = supersig, iupac = TRUE)

}
