% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/combineSubsamples.R
\name{combineSubsamples}
\alias{combineSubsamples}
\title{combine multiple subsamples objects}
\usage{
combineSubsamples(...)
}
\arguments{
\item{...}{Two or more subsamples objects}
}
\value{
subSeq object
}
\description{
Given two or more subsamples objects, combine them into one larger object, on
which we can perform all the usual analyses and plots.
}
\details{
If there are columns in some subsamples objects that are not in others,
the missing values will be filled with NA
}
\examples{
# see ?subsample to see how ss is generated
data(ss)

# combine multiple subsampling objects (in this example they happen to be the same object)
ss_new <- combineSubsamples(ss, ss)
}

