% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_list_class.R
\name{model_seq}
\alias{model_seq}
\alias{model_train,model_seq,DatasetExperiment-method}
\alias{model_predict,model_seq,DatasetExperiment-method}
\alias{[,model_seq,ANY,ANY,ANY-method}
\alias{[<-,model_seq,ANY,ANY,ANY-method}
\alias{models,model_seq-method}
\alias{models<-,model_seq,list-method}
\alias{length,model_seq-method}
\alias{+,model,model_seq-method}
\alias{+,model_seq,model-method}
\alias{+,model,model-method}
\alias{predicted,model_seq-method}
\alias{model_apply,model_seq,DatasetExperiment-method}
\title{model_seq class}
\usage{
model_seq(...)

\S4method{model_train}{model_seq,DatasetExperiment}(M, D)

\S4method{model_predict}{model_seq,DatasetExperiment}(M, D)

\S4method{[}{model_seq,ANY,ANY,ANY}(x, i)

\S4method{[}{model_seq,ANY,ANY,ANY}(x, i) <- value

\S4method{models}{model_seq}(ML)

\S4method{models}{model_seq,list}(ML) <- value

\S4method{length}{model_seq}(x)

\S4method{+}{model,model_seq}(e1, e2)

\S4method{+}{model_seq,model}(e1, e2)

\S4method{+}{model,model}(e1, e2)

\S4method{predicted}{model_seq}(M)

\S4method{model_apply}{model_seq,DatasetExperiment}(M, D)
}
\arguments{
\item{...}{named slots and their values.}

\item{M}{a model object}

\item{D}{a dataset object}

\item{x}{a model_seq object}

\item{i}{index}

\item{value}{value}

\item{ML}{a model_seq object}

\item{e1}{a model or model_seq object}

\item{e2}{a model or model_seq object}
}
\value{
model sequence

model sequence

model at the given index in the sequence

model sequence with the model at index i replaced

a list of models in the sequence

a model sequence containing the input models

the number of models in the sequence

a model sequence with the additional model appended to the front of
the sequence

a model sequence with the additional model appended to the end of the
sequence

a model sequence

the predicted output of the last model in the sequence
}
\description{
A class for (ordered) lists of models
}
\examples{
MS = model_seq()
MS = model() + model()
MS = example_model() + example_model()
MS = model_train(MS,DatasetExperiment())
D = DatasetExperiment()
MS = example_model() + example_model()
MS = model_train(MS,D)
MS = model_predict(MS,D)
MS = model() + model()
MS[2]

MS = model() + model()
MS[3] = model()

MS = model() + model()
L = models(MS)

MS = model_seq()
L = list(model(),model())
models(MS) = L

MS = model() + model()
length(MS) # 2

MS = model() + model()
M = model()
MS = M + MS

MS = model() + model()
M = model()
MS = MS + M

MS = model() + model()

D = DatasetExperiment()
M = example_model()
M = model_train(M,D)
M = model_predict(M,D)
p = predicted(M)
D = DatasetExperiment()
MS = example_model() + example_model()
MS = model_apply(MS,D)

}
