% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/entity_class.R
\name{max_length}
\alias{max_length}
\alias{entity}
\alias{value,entity-method}
\alias{value<-,entity-method}
\alias{max_length,entity-method}
\alias{max_length<-,entity-method}
\title{get the max value vector length for an entity}
\usage{
max_length(obj)

entity(
  name,
  description = character(0),
  type = "character",
  value = NULL,
  max_length = Inf,
  ...
)

\S4method{value}{entity}(obj)

\S4method{value}{entity}(obj) <- value

\S4method{max_length}{entity}(obj)

\S4method{max_length}{entity}(obj) <- value
}
\arguments{
\item{obj}{An entity object}

\item{name}{the name of the object}

\item{description}{a description of the object}

\item{type}{the type of the struct object}

\item{value}{The value of the parameter/outputs}

\item{max_length}{Maximum length of value vector (default 1)}

\item{...}{additional inputs to the struct_class object}
}
\value{
max value vector length for an entity

An entity object
}
\description{
A base class in the \pkg{struct} package. Not normally called directly.
An entity object is used to store information about a parameter or output_
The standard 'name','description' and 'type' slots are included, along with
'value' for storing the value of the parameter and 'max_length' for restricting
the length of 'value' if needed.
}
\details{
Entity objects are usually defined in the prototype of another object, but
can be extracted using \code{param_obj} and \code{output_obj}.
}
\examples{
# Create a new entity object
E = entity(
    name = 'example',
    description = 'this is an example',
    type = 'numeric',
    value = 1
)

# Get/set the value of the entity object
value(E)
value(E) = 10
}
