% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paretoscale_class.R
\name{pareto_scale}
\alias{pareto_scale}
\title{Pareto scaling}
\usage{
pareto_scale(...)
}
\arguments{
\item{...}{Additional slots and values passed to \code{struct_class}.}
}
\value{
A  \code{pareto_scale} object with the following \code{output} slots:
\tabular{ll}{
\code{scaled} \tab          (DatasetExperiment)  \cr
\code{mean} \tab          (numeric)  \cr
\code{sd} \tab          (numeric)  \cr
}
}
\description{
The mean sample is subtracted from all samples and then scaled by the square root of the standard deviation. The transformed data has zero mean.
}
\section{Inheritance}{

A \code{pareto_scale} object inherits the following \code{struct} classes: \cr\cr
\verb{[pareto_scale]} >> \verb{[model]} >> \verb{[struct_class]}
}

\examples{
M = pareto_scale()

D = iris_DatasetExperiment()
M = pareto_scale()
M = model_train(M,D)
M = model_predict(M,D)
}
