% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kfold_xval_class.R
\name{kfold_xval}
\alias{kfold_xval}
\title{k-fold cross-validation}
\usage{
kfold_xval(folds = 10, method = "venetian", factor_name, collect = NULL, ...)
}
\arguments{
\item{folds}{(numeric, integer) The number of cross-validation folds. The default is \code{10}.\cr}

\item{method}{(character) Fold selection method. Allowed values are limited to the following: \itemize{ \item{\code{"venetian"}: Every nth sample is assigned to the same fold, where n is the number of folds.}\item{\code{"blocks"}: Blocks of adjacent samples are assigned to the same fold.}\item{\code{"random"}: Samples are randomly assigned to a fold.}} The default is \code{"venetian"}.}

\item{factor_name}{(character) The name of a sample-meta column to use.}

\item{collect}{(NULL, character) The name of a model output to collect over all bootstrap repetitions, in addition to the input metric. The default is \code{NULL}.}

\item{...}{Additional slots and values passed to \code{struct_class}.}
}
\value{
A  \code{kfold_xval} object with the following \code{output} slots:
\tabular{ll}{
\code{results} \tab          (data.frame)  \cr
\code{metric} \tab          (data.frame)  \cr
\code{metric.train} \tab          (numeric)  \cr
\code{metric.test} \tab          (numeric)  \cr
\code{collected} \tab          (list)  \cr
}
}
\description{
k-fold cross-validation is an iterative approach applied to validate models. The samples are divided into k "folds", or subsets. Each subset is excluded from model training and used for model validation once, resulting in a single left-out prediction for each sample. Model performance metrics are then computed for the training and test sets across all folds.
}
\section{Inheritance}{

A \code{kfold_xval} object inherits the following \code{struct} classes: \cr\cr
\verb{[kfold_xval]} >> \verb{[resampler]} >> \verb{[iterator]} >> \verb{[struct_class]}
}

\examples{
M = kfold_xval(
      folds = 5,
      method = "random",
      factor_name = "V1",
      collect = NULL)

D = iris_DatasetExperiment()
I = kfold_xval(factor_name='Species') *
    (mean_centre() + PLSDA(factor_name='Species'))
I = run(I,D,balanced_accuracy())

}
