% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fold_change_class.R
\name{fold_change_plot}
\alias{fold_change_plot}
\title{Fold change plot}
\usage{
fold_change_plot(number_features = 20, orientation = "portrait", ...)
}
\arguments{
\item{number_features}{(numeric) The number randomly selected features to plot, or
a list of column numbers. The default is \code{20}.\cr}

\item{orientation}{(character) Plot orientation. Allowed values are limited to the following: \itemize{ \item{\code{"landscape"}: Features are plotted on the y-axis.}\item{\code{"portrait"}: Features are plotted on the x-axis.}} The default is \code{"portrait"}.}

\item{...}{Additional slots and values passed to \code{struct_class}.}
}
\value{
A  \code{
fold_change_plot
} object. This object has no \code{output} slots.
See \code{\link[struct]{chart_plot}} in the \code{struct} package to plot this chart object.
}
\description{
A plot of fold changes calculated for a chosen subset of features. A predefined fold change threshold is indicated by shaded regions.
}
\section{Inheritance}{

A \code{fold_change_plot} object inherits the following \code{struct} classes: \cr\cr
\verb{[fold_change_plot]} >> \verb{[chart]} >> \verb{[struct_class]}
}

\examples{
M = fold_change_plot(
      number_features = 10,
      orientation = "portrait")

C = fold_change_plot()
}
