% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_na_count.R
\name{filter_na_count}
\alias{filter_na_count}
\title{Minimum number of measured values filter}
\usage{
filter_na_count(threshold, factor_name, ...)
}
\arguments{
\item{threshold}{(numeric) The minimum number of samples in each group/interaction.}

\item{factor_name}{(character) The name of a sample-meta column to use.}

\item{...}{Additional slots and values passed to \code{struct_class}.}
}
\value{
A  \code{filter_na_count} object with the following \code{output} slots:
\tabular{ll}{
\code{filtered} \tab          (DatasetExperiment) A DatasetExperiment object containing the filtered data. \cr
\code{count} \tab          (data.frame) The number of measured values in each group/interaction. \cr
\code{na_count} \tab          (data.frame) The number of missing values in each group/interaction. \cr
\code{flags} \tab          (data.frame) Flags to indicate which features were removed. \cr
}
}
\description{
The number of measured values is counted for each feature, and any feature with less than a predefined minimum number of values in each group is removed. If there are several factors, then the threshold is applied so that the minimum number of samples is present for all combinations (interactions) of groups.
}
\section{Inheritance}{

A \code{filter_na_count} object inherits the following \code{struct} classes: \cr\cr
\verb{[filter_na_count]} >> \verb{[model]} >> \verb{[struct_class]}
}

\examples{
M = filter_na_count(
      threshold = 2,
      factor_name = "V1")

D = MTBLS79_DatasetExperiment()
M = filter_na_count(threshold=3,factor_name='Class')
M = model_apply(M,D)
}
