% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/equal_split_class.R
\name{equal_split}
\alias{equal_split}
\title{Equal group sized sampling}
\usage{
equal_split(p_train = 1, factor_name, ...)
}
\arguments{
\item{p_train}{(numeric) The proportion of samples selected for the training set. The default is \code{1}.\cr}

\item{factor_name}{(character) The name of a sample-meta column to use.}

\item{...}{Additional slots and values passed to \code{struct_class}.}
}
\value{
A  \code{equal_split} object with the following \code{output} slots:
\tabular{ll}{
\code{training} \tab          (DatasetExperiment) A DatasetExperiment object containing samples selected for the training set. \cr
\code{testing} \tab          (DatasetExperiment) A DatasetExperiment object containing samples selected for the testing set. \cr
}
}
\description{
Samples are randomly chosen from each level such that the training set has equal numbers of samples for all levels. The number of samples is based on the input proportion and the smallest group size.
}
\section{Inheritance}{

A \code{equal_split} object inherits the following \code{struct} classes: \cr\cr
\verb{[equal_split]} >> \verb{[split_data]} >> \verb{[model]} >> \verb{[struct_class]}
}

\examples{
M = equal_split(
      factor_name = "V1",
      p_train = 0.75)

D = iris_DatasetExperiment()
M = equal_split(factor_name='Species')
M = model_apply(M,D)
}
