% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/d_ratio_filter_class.R
\name{dratio_filter}
\alias{dratio_filter}
\title{Dispersion ratio filter}
\usage{
dratio_filter(
  threshold = 20,
  qc_label = "QC",
  factor_name,
  method = "ratio",
  dispersion = "sd",
  ...
)
}
\arguments{
\item{threshold}{(numeric) The threshold above which features are removed. The default is \code{20}.\cr}

\item{qc_label}{(character) The label used to identify QC samples. The default is \code{"QC"}.}

\item{factor_name}{(character) The name of a sample-meta column to use.}

\item{method}{(character) dratio method. Allowed values are limited to the following: \itemize{ \item{\code{"ratio"}: Dispersion of the QCs divided by the dispersion of the samples. Corresponds to Eq 4 in  Broadhurst et al (2018).}\item{\code{"euclidean"}: Dispersion of the QCs divided by the euclidean length of the total dispersion. Total dispersion is estimated from the QC and Sample dispersion by assuming that they are orthogonal. Corresponds to Eq 5 in Broadhurst et al (2018).}} The default is \code{"ratio"}.}

\item{dispersion}{(character) Dispersion method. Allowed values are limited to the following: \itemize{ \item{\code{"sd"}: Dispersion is estimated using the standard deviation.}\item{\code{"mad"}: Dispersion is estimated using the median absolute deviation.}} The default is \code{"sd"}.}

\item{...}{Additional slots and values passed to \code{struct_class}.}
}
\value{
A  \code{dratio_filter} object with the following \code{output} slots:
\tabular{ll}{
\code{filtered} \tab          (DatasetExperiment) A DatasetExperiment object containing the filtered data. \cr
\code{flags} \tab          (data.frame) Flag indicating whether the feature was rejected by the filter or not. \cr
\code{d_ratio} \tab          (data.frame)  \cr
}
}
\description{
The dispersion ratio (d-ratio) compares the standard deviation (or non-parametric equivalent) of the Quality Control (QC) samples relative to the standard deviation (or non-parametric equivalent) of the samples for each feature. If the d-ratio is greater than a predefined threshold then the observed sample variance could be due to technical variance and the feature is removed.
}
\section{Inheritance}{

A \code{dratio_filter} object inherits the following \code{struct} classes: \cr\cr
\verb{[dratio_filter]} >> \verb{[model]} >> \verb{[struct_class]}
}

\examples{
M = dratio_filter(
      threshold = 20,
      qc_label = "QC",
      factor_name = "V1",
      method = "ratio",
      dispersion = "sd")

D = MTBLS79_DatasetExperiment()
M = dratio_filter(threshold=20,qc_label='QC',factor_name='Class')
M = model_apply(M,D)
}
\references{
Broadhurst D, Goodacre R, Reinke SN, Kuligowski J, Wilson ID, Lewis MR,
Dunn WB (2018). "Guidelines and considerations for the use of system
suitability and quality control samples in mass spectrometry assays
applied in untargeted clinical metabolomic studies." \emph{Metabolomics},
\emph{14}(6).
}
