% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCA_class.R
\name{PCA}
\alias{PCA}
\title{Principal Component Analysis (PCA)}
\usage{
PCA(number_components = 2, ...)
}
\arguments{
\item{number_components}{(numeric, integer) The number of Principal Components calculated. The default is \code{2}.\cr}

\item{...}{Additional slots and values passed to \code{struct_class}.}
}
\value{
A  \code{PCA} object with the following \code{output} slots:
\tabular{ll}{
\code{scores} \tab          (DatasetExperiment) A matrix of PCA scores where each column corresponds to a Principal Component. \cr
\code{loadings} \tab          (data.frame)  \cr
\code{eigenvalues} \tab          (data.frame)  \cr
\code{ssx} \tab          (numeric)  \cr
\code{correlation} \tab          (data.frame)  \cr
\code{that} \tab          (DatasetExperiment)  \cr
}
}
\description{
PCA is a multivariate data reduction technique. It summarises the data in a smaller number of Principal Components that maximise variance.
}
\section{Inheritance}{

A \code{PCA} object inherits the following \code{struct} classes: \cr\cr
\verb{[PCA]} >> \verb{[model]} >> \verb{[struct_class]}
}

\examples{
M = PCA(
      number_components = 2)

}
