% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oplsr_class.R
\name{OPLSR}
\alias{OPLSR}
\title{Orthogonal Partial Least Squares regression}
\usage{
OPLSR(number_components = 2, factor_name, ...)
}
\arguments{
\item{number_components}{(numeric, integer) The number of orthgonal components. The default is \code{2}.\cr}

\item{factor_name}{(character) The name of a sample-meta column to use.}

\item{...}{Additional slots and values passed to \code{struct_class}.}
}
\value{
A  \code{OPLSR} object with the following \code{output} slots:
\tabular{ll}{
\code{opls_model} \tab          (list)  \cr
\code{filtered} \tab          (DatasetExperiment)  \cr
\code{orthogonal} \tab          (DatasetExperiment)  \cr
}
}
\description{
OPLS splits a data matrix into two parts. One part
contains information orthogonal to the input vector, and the other is non-orthogonal.
}
\section{Inheritance}{

A \code{OPLSR} object inherits the following \code{struct} classes: \cr\cr
\verb{[OPLSR]} >> \verb{[model]} >> \verb{[struct_class]}
}

\examples{
M = OPLSR(
      number_components = 2,
      factor_name = "V1")

M = OPLSR('number_components'=2,factor_name='Species')
}
