% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allGenerics.R, R/accessors.R
\docType{methods}
\name{stageWiseAdjustment}
\alias{stageWiseAdjustment}
\alias{stageWiseAdjustment}
\alias{stageWiseAdjustment,stageR}
\alias{stageWiseAdjustment,stageRTx}
\alias{stageWiseAdjustment,stageRTx,character,numeric-method}
\title{adjust p-values in a two-stage analysis}
\usage{
stageWiseAdjustment(object, method, alpha, ...)

\S4method{stageWiseAdjustment}{stageR,character,numeric}(object, method, alpha,
  adjustment = NULL, ...)

\S4method{stageWiseAdjustment}{stageRTx,character,numeric}(object, method,
  alpha, tx2gene, ...)
}
\arguments{
\item{object}{an object of the \code{\link{stageRClass}} class.}

\item{method}{Character string indicating the method used for FWER correction in the confirmation stage of the stage-wise analysis. Can be any of \code{"none"}, \code{"holm"}, \code{"dte"}, \code{"dtu"}, \code{"user"}. \code{"none"} will not adjust the p-values in the confirmation stage. \code{"holm"} is an adapted Holm procedure for a stage-wise analysis, where the method takes into account the fact that genes in the confirmation stage have already passed the screening stage, hence the procedure will be more powerful for the most significant p-value as compared to the standard Holm procedure. \code{"dte"} is the adjusted Holm-Shaffer procedure for differential transcript expression analysis. \code{"dtu"} is the adjusted Holm-Shaffer procedure for differential transcript usage. \code{"user"} indicates a user-defined adjustment that should be specified with the \code{adjustment} argument.}

\item{alpha}{the OFDR on which to control the two-stage analysis.}

\item{...}{Additional arguments passed to \code{.stageWiseTest}}

\item{adjustment}{a user-defined adjustment of the confirmation stage p-values. Only applicable when \code{method} is \code{"user"} and ignored otherwise.}

\item{tx2gene}{Only applicable when  \code{method} is \code{"dte"} or \code{"dtu"}.  A \code{\link[base]{data.frame}} with transcript IDs in the first columns and gene IDs in the second column. The rownames from \code{pConfirmation} must be contained in the transcript IDs from \code{tx2gene}, and the names from \code{pScreen} must be contained in the gene IDs.}
}
\value{
A stageR/stageRTx object with stage-wise adjusted p-values.
}
\description{
This function will adjust p-values according to a hierarchical two-stage testing paradigm.
}
\section{Methods (by class)}{
\itemize{
\item \code{object = stageRTx,method = character,alpha = numeric}: Adjust p-values in a two-stage analysis
}}

\examples{
pScreen=c(seq(1e-10,1e-2,length.out=100),seq(1e-2,.2,length.out=100),seq(.2,1,length.out=100))
names(pScreen)=paste0("gene",1:300)
pConfirmation=matrix(runif(900),nrow=300,ncol=3)
dimnames(pConfirmation)=list(paste0("gene",1:300),c("H1","H2","H3"))
stageRObj <- stageR(pScreen=pScreen, pConfirmation=pConfirmation)
stageRObj <- stageWiseAdjustment(stageRObj, method="holm", alpha=0.05)
getAdjustedPValues(stageRObj, onlySignificantGenes=TRUE, order=TRUE)
}
\references{
Van den Berge K., Soneson C., Robinson M.D., Clement L. (2017). stageR: a general stage-wise method for controlling the gene-level false discovery rate in differential expression and differential transcript usage. Genome Biology 18:151. https://doi.org/10.1186/s13059-017-1277-0
R. Heller, E. Manduchi, G. R. Grant, and W. J. Ewens, "A flexible two-stage procedure for identifying gene sets that are differentially expressed." Bioinformatics (Oxford, England), vol. 25, pp. 1019-25, 2009.

S. Holm, "A Simple Sequentially Rejective Multiple Test Procedure," Scandinavian Journal of Statistics, vol. 6, no. 2, pp. 65-70, 1979.
J. P. Shaffer, "Modified Sequentially Rejective Multiple Test Procedures," Journal of the American Statistical Association, vol. 81, p. 826, 1986.
}
