% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constructors.R
\name{stageRTx}
\alias{stageRTx}
\title{Create stageRTx object.}
\usage{
stageRTx(pScreen, pConfirmation, pScreenAdjusted = FALSE, tx2gene)
}
\arguments{
\item{pScreen}{A vector of screening hypothesis p-values.}

\item{pConfirmation}{A matrix of confirmation hypothesis p-values. The number of rows should be equal to the length of \code{pScreen}.}

\item{pScreenAdjusted}{logical, indicating whether the supplied p-values for the screening hypothesis have already been adjusted for multiplicity according to the FDR.}

\item{tx2gene}{Only applicable for transcript-level analysis. A \code{\link[base]{data.frame}} with transcript IDs in the first columns and gene IDs in the second column. The rownames from \code{pConfirmation} must be contained in the transcript IDs from \code{tx2gene}, and the names from \code{pScreen} must be contained in the gene IDs.}

\item{...}{Additional arguments.}
}
\value{
An instance of an object of the \code{\link{stageRTxClass}}
}
\description{
Constructor function for \code{\link{stageRTxClass}}. A stageR class is a class used for stage-wise analysis in high throughput settings.
In its most basic form, it consists of a vector of p-values for the screening hypothesis, a matrix of p-values for the confirmation hypotheses and a tx2gene object for linking genes to transcripts.
}
\examples{
# create a \\code{\\link{stageRClass}} object
pScreen <- runif(10)
names(pScreen) <- paste0("gene",1:10)
pConfirmation <- matrix(runif(30),nrow=10,ncol=3)
rownames(pConfirmation) <-  paste0("gene",1:10)
stageRObj <- stageR(pScreen=pScreen, pConfirmation=pConfirmation)
pConfirmationTx <- matrix(runif(10),ncol=1)
names(pScreen) <- paste0("gene",rep(1:2,each=5))
stageRObj <- stageRTx(pScreen=pScreen, pConfirmation=pConfirmationTx, tx2gene=data.frame(transcripts=paste0("transcript",1:10),genes=paste0("gene",rep(1:2,each=5))))
}
\references{
Van den Berge K., Soneson C., Robinson M.D., Clement L. (2017). stageR: a general stage-wise method for controlling the gene-level false discovery rate in differential expression and differential transcript usage. Genome Biology 18:151. https://doi.org/10.1186/s13059-017-1277-0
}
