% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constructors.R
\name{stageR}
\alias{stageR}
\title{Create stageR object}
\usage{
stageR(pScreen, pConfirmation, pScreenAdjusted = FALSE)
}
\arguments{
\item{pScreen}{A vector of screening hypothesis p-values.}

\item{pConfirmation}{A matrix of confirmation hypothesis p-values. When constructing a \code{\link{stageRClass}} object, the number of rows should be equal to the length of \code{pScreen}. For a \code{\link{stageRTxClass}} object, the dimensions can be different.}

\item{pScreenAdjusted}{logical, indicating whether the supplied p-values for the screening hypothesis have already been adjusted for multiplicity according to the FDR.}

\item{...}{Additional arguments.}
}
\value{
An instance of an object of the \code{\link{stageRClass}}
}
\description{
Constructor function for \code{\link{stageRClass}}. A stageR class is a class used for stage-wise analysis in high throughput settings.
In its most basic form, it consists of a vector of p-values for the screening hypothesis and a matrix of p-values for the confirmation hypotheses.
}
\examples{
# create a \\code{\\link{stageRClass}} object
pScreen <- runif(10)
names(pScreen) <- paste0("gene",1:10)
pConfirmation <- matrix(runif(30),nrow=10,ncol=3)
rownames(pConfirmation) <-  paste0("gene",1:10)
stageRObj <- stageR(pScreen=pScreen, pConfirmation=pConfirmation)
pConfirmationTx <- matrix(runif(10),ncol=1)
names(pScreen) <- paste0("gene",rep(1:2,each=5))
stageRObj <- stageRTx(pScreen=pScreen, pConfirmation=pConfirmationTx, tx2gene=data.frame(transcripts=paste0("transcript",1:10),genes=paste0("gene",rep(1:2,each=5))))
}
\references{
Van den Berge K., Soneson C., Robinson M.D., Clement L. (2017). stageR: a general stage-wise method for controlling the gene-level false discovery rate in differential expression and differential transcript usage. Genome Biology 18:151. https://doi.org/10.1186/s13059-017-1277-0
}
