% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allGenerics.R, R/accessors.R
\docType{methods}
\name{isAdjusted}
\alias{isAdjusted}
\alias{isAdjusted}
\alias{isAdjusted,stageR}
\alias{isAdjusted,stageRTx}
\alias{isAdjusted,stageRTx-method}
\title{Has stage-wise adjustment already been performed on the object?}
\usage{
isAdjusted(object, ...)

\S4method{isAdjusted}{stageR}(object, ...)

\S4method{isAdjusted}{stageRTx}(object, ...)
}
\arguments{
\item{object}{an object of the \code{\link{stageRClass}} or \code{stageRTxClass} class.}

\item{...}{Additional arguments}
}
\value{
A logical stating whether the p-values have already been adjusted according to the stage-wise method
}
\description{
This functions returns a logical stating whether the p-values have already been adjusted according to the stage-wise method.
}
\section{Methods (by class)}{
\itemize{
\item \code{stageRTx}: Has stage-wise adjustment already been performed on the object?
}}

\examples{
pScreen=c(seq(1e-10,1e-2,length.out=100),seq(1e-2,.2,length.out=100),seq(.2,1,length.out=100))
names(pScreen)=paste0("gene",1:300)
pConfirmation=matrix(runif(900),nrow=300,ncol=3)
dimnames(pConfirmation)=list(paste0("gene",1:300),c("H1","H2","H3"))
stageRObj <- stageR(pScreen=pScreen, pConfirmation=pConfirmation)
isAdjusted(stageRObj)
stageRObj <- stageWiseAdjustment(stageRObj, method="holm", alpha=0.05)
isAdjusted(stageRObj)
}
\references{
Van den Berge K., Soneson C., Robinson M.D., Clement L. (2017). stageR: a general stage-wise method for controlling the gene-level false discovery rate in differential expression and differential transcript usage. Genome Biology 18:151. https://doi.org/10.1186/s13059-017-1277-0
}
