% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allGenerics.R, R/accessors.R
\docType{methods}
\name{getPConfirmation}
\alias{getPConfirmation}
\alias{getPConfirmation}
\alias{getPConfirmation,stageR}
\alias{getPConfirmation,stageRTx}
\alias{getPConfirmation,stageRTx-method}
\title{Return unadjusted confirmation hypothesis p-values from a \code{\link{stageRClass}} object.}
\usage{
getPConfirmation(object, ...)

\S4method{getPConfirmation}{stageR}(object)

\S4method{getPConfirmation}{stageRTx}(object)
}
\arguments{
\item{object}{an object of the \code{\link{stageRClass}} class.}
}
\value{
A matrix of the unadjusted p-values to be used in the confirmation stage.
}
\description{
Return unadjusted confirmation hypothesis p-values from a \code{\link{stageRClass}} object.
}
\section{Methods (by class)}{
\itemize{
\item \code{stageRTx}: Return unadjusted confirmation hypothesis p-values from a \code{\link{stageRClass}} object.
}}

\examples{
pScreen=c(seq(1e-10,1e-2,length.out=100),seq(1e-2,.2,length.out=100),seq(.2,1,length.out=100))
names(pScreen)=paste0("gene",1:300)
pConfirmation=matrix(runif(900),nrow=300,ncol=3)
dimnames(pConfirmation)=list(paste0("gene",1:300),c("H1","H2","H3"))
stageRObj <- stageR(pScreen=pScreen, pConfirmation=pConfirmation)
getPConfirmation(stageRObj)
}
