% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allGenerics.R, R/accessors.R
\docType{methods}
\name{adjustedAlphaLevel}
\alias{adjustedAlphaLevel}
\alias{adjustedAlphaLevel}
\alias{adjustedAlphaLevel,stageR}
\alias{adjustedAlphaLevel,stageRTx}
\alias{adjustedAlphaLevel,stageRTx-method}
\title{Get adjusted significance level from the screening stage.}
\usage{
adjustedAlphaLevel(object, ...)

\S4method{adjustedAlphaLevel}{stageR}(object)

\S4method{adjustedAlphaLevel}{stageRTx}(object)
}
\arguments{
\item{object}{an object of the \code{\link{stageRClass}} class.}
}
\value{
Scalar, the adjusted significance level from the screening stage.
}
\description{
This functions returns the adjusted significance level from the screening stage that should be used to compare confirmation stage FWER adjusted p-values against.
}
\details{
The adjusted significance level is calculated as the fraction of significant features in the screening stage multiplied the alpha level.
}
\section{Methods (by class)}{
\itemize{
\item \code{stageRTx}: Get adjusted significance level from the screening stage.
}}

\examples{
pScreen=c(seq(1e-10,1e-2,length.out=100),seq(1e-2,.2,length.out=100),seq(.2,1,length.out=100))
names(pScreen)=paste0("gene",1:300)
pConfirmation=matrix(runif(900),nrow=300,ncol=3)
dimnames(pConfirmation)=list(paste0("gene",1:300),c("H1","H2","H3"))
stageRObj <- stageR(pScreen=pScreen, pConfirmation=pConfirmation, pScreenAdjusted=FALSE)
stageRObj <- stageWiseAdjustment(stageRObj, method="holm", alpha=0.05)
adjustedAlphaLevel(stageRObj)
# @method stageR-method
}
\references{
Van den Berge K., Soneson C., Robinson M.D., Clement L. (2017). stageR: a general stage-wise method for controlling the gene-level false discovery rate in differential expression and differential transcript usage. Genome Biology 18:151. https://doi.org/10.1186/s13059-017-1277-0

R. Heller, E. Manduchi, G. R. Grant, and W. J. Ewens, "A flexible two-stage procedure for identifying gene sets that are differentially expressed." Bioinformatics (Oxford, England), vol. 25, pp. 1019-25, 2009.
}
\seealso{
\code{\link{stageR}}, \code{\link{stageRClass}}
}
