% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rasterPrep.R
\name{rasterPrep}
\alias{rasterPrep}
\title{Raster layer preparation}
\usage{
rasterPrep(sampleInfo, n)
}
\arguments{
\item{sampleInfo}{A data.frame contains the pixel information and cluster labels for each barcode of a human breast cancer sample.
The index contains barcodes, and at least three other columns that have these information are required and the column names should be the same as following:
"imagerow": The row pixel coordinate of the center of the spot
"imagecol": The column pixel coordinate of the center of the spot
"Cluster": The label that corresponding to this barcode}

\item{n}{buffer for extent (from function extentBuffer).}
}
\value{
This function returns a class of RasterLayer. This is a raster layer with calculated resolution and extent with buffer applied
}
\description{
When sample coordinates finds a suitable buffer to ensure that each cluster is not lost
in the process of converting the spot to pixel,
apply this buffer to this function to find a suitable rectangle for the rasterlayer
}
\examples{
fpath <- system.file("extdata", "dataframe.rda", package="stJoincount")
load(fpath)
raster <- rasterPrep(humanBC, 15)
}
