% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\docType{methods}
\name{countMatrix}
\alias{countMatrix}
\alias{countMatrix,srnadiffExp-method}
\title{Accessors for the 'countMatrix' slot of an srnadiffExp object}
\usage{
\S4method{countMatrix}{srnadiffExp}(object)
}
\arguments{
\item{object}{An \code{srnadiffExp} object.}
}
\value{
A matrix with the number of reads for each regions, and each sample.
}
\description{
The \code{countMatrix} slot holds the count matrix from the DERs found.
}
\details{
In the last step of an sRNA-diff approach, the potential DERs is assessed.
Reads (including fractions of reads) that overlap each expressed region
are counted to arrive at a count matrix with one row per region and one
column per sample. This matrix to been used for quantify the statistic
signification of the finded regions.
}
\examples{
srnaExp <- srnadiffExample()
srnaExp <- srnadiff(srnaExp)
countMatrix(srnaExp)

}
