\name{qqplot_condition_exp}
\alias{qqplot_condition_exp}
\title{
  Q-Q plot for examing the distributions across submatrices of a
  correlation matrix.
}
\description{
  We partition the correlation matrix into 10x10 bins of equal size,
  with genes ordered according to expression level. As reference bin, we
  choose the (9,9) bin (ie. the almost-highest expressed genes). We then
  make a QQ-plot of the (i,j)'th submatrix vs. the (9,9) submatrix. See
  the SpQN paper for detail on these choices.
}
\usage{
qqplot_condition_exp(cor_mat,ave_exp, i,j)
}
\arguments{
  \item{cor_mat}{Matrix, correlation matrix, generated by gene expression matrix.}
  \item{ave_exp}{Vector, average expression level of each gene for the normalized expression matrix.}
  \item{i}{Integer, row number of the submatrix (see details).}
  \item{j}{Integer, column number of the submatrix (see details).}
}
\note{
  The mnemonic for \code{condition_exp} is \sQuote{conditional on
    expression}.
}
\value{
  Invoked for the side effect of producing a plot.
}
\examples{
if(require(spqnData)) {
  data(gtex.4k)
  cor_mat <- cor(t(assay(gtex.4k)))
  ave_logrpkm <- rowData(gtex.4k)$ave_logrpkm
  qqplot_condition_exp(cor_mat, ave_exp=ave_logrpkm, 1, 1)
}
}
