% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/splatPop-simulate.R
\name{splatPopSimulate}
\alias{splatPopSimulate}
\title{splatPop simulation}
\usage{
splatPopSimulate(
  params = newSplatPopParams(nGenes = 50),
  vcf = mockVCF(),
  method = c("single", "groups", "paths"),
  gff = NULL,
  eqtl = NULL,
  means = NULL,
  key = NULL,
  counts.only = FALSE,
  sparsify = TRUE,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{params}{SplatPopParams object containing parameters for population
scale simulations. See \code{\link{SplatPopParams}} for details.}

\item{vcf}{VariantAnnotation object containing genotypes of samples.}

\item{method}{which simulation method to use. Options are "single" which
produces a single population, "groups" which produces distinct groups
(eg. cell types), "paths" which selects cells from continuous
trajectories (eg. differentiation processes).}

\item{gff}{Either NULL or a data.frame object containing a GFF/GTF file.}

\item{eqtl}{Either NULL or if simulating population parameters directly from
empirical data, a data.frame with empirical/desired eQTL results.
To see required format, run `mockEmpiricalSet()` and see eqtl output.}

\item{means}{Either NULL or if simulating population parameters directly from
empirical data, a Matrix of real gene means across a population, where
each row is a gene and each column is an individual in the population.
To see required format, run `mockEmpiricalSet()` and see means output.}

\item{key}{Either NULL or a data.frame object containing a full or partial
splatPop key.}

\item{counts.only}{logical. Whether to save only counts in sce object.}

\item{sparsify}{logical. Whether to automatically convert assays to sparse
matrices if there will be a size reduction.}

\item{verbose}{logical. Whether to print progress messages.}

\item{...}{any additional parameter settings to override what is provided in
\code{params}.}
}
\value{
SingleCellExperiment object containing simulated counts,
intermediate values like the gene means simulated in `splatPopSimulateMeans`,
and information about the differential expression and eQTL effects assigned
to each gene.
}
\description{
Simulate scRNA-seq count data using the splat model for a population of
individuals with correlation structure.
}
\details{
This functions is for simulating data in a single step. It consists of a
call to \code{\link{splatPopSimulateMeans}}, which simulates a mean
expression level per gene per sample, followed by a call to
\code{\link{splatPopSimulateSC}}, which uses the splat model to simulate
single-cell counts per individual. Please see the documentation for those
functions for more details.
}
\examples{
\donttest{
if (requireNamespace("VariantAnnotation", quietly = TRUE) &&
    requireNamespace("preprocessCore", quietly = TRUE)) {
    vcf <- mockVCF()
    gff <- mockGFF()
    sim <- splatPopSimulate(vcf = vcf, gff = gff, sparsify = FALSE)
}
}

}
\seealso{
\code{\link{splatPopSimulateMeans}}, \code{\link{splatPopSimulateSC}}
}
