% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/splatPop-simulate.R
\name{splatPopSimEffects}
\alias{splatPopSimEffects}
\title{Add eQTL effects to means matrix}
\usage{
splatPopSimEffects(id, key, conditions, vcf, means.pop)
}
\arguments{
\item{id}{The group ID (e.g. "global" or "g1")}

\item{key}{Partial splatPop key data.frame.}

\item{conditions}{array of condition assignments for each sample}

\item{vcf}{VariantAnnotation object containing genotypes of samples.}

\item{means.pop}{Population mean gene expression matrix}
}
\value{
data.frame of gene mean expression levels WITH eQTL effects.
}
\description{
Add eQTL effects and non-eQTL group effects to simulated means matrix.
The eQTL effects are incorporated using the following equation:
\deqn{Ygs = (ESg x Mgs x Gs) + Mgs }
Where Ygs is the mean for gene g and sample s, ESg is the effect size
assigned to g, Mgs is the mean expression assigned to g for s, and Gs
is the genotype (number of minor alleles) for s. Non-eQTL group effects are
incorporated as:
\deqn{Ygs = Mgs x GEg}
Where GEg is the group effect (i.e. differential expression) assigned to g.
To simulate multiple gene mean matrices with different group effects, this
function can be run with `id` designating the group id.
}
\keyword{internal}
