% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/splatPop-simulate.R
\name{splatPopQuantNorm}
\alias{splatPopQuantNorm}
\title{Quantile normalize by sample to fit sc expression distribution.}
\usage{
splatPopQuantNorm(params, means)
}
\arguments{
\item{params}{SplatPopParams object containing parameters for population
scale simulations. See \code{\link{SplatPopParams}} for details.}

\item{means}{Mean gene expression matrix with eQTL effects.}
}
\value{
matrix of quantile normalized gene mean expression levels.
}
\description{
For each sample, expression values are quantile normalized (qgamma)
using the gamma distribution parameterized from splatEstimate(). This ensures
the simulated gene means reflect the distribution expected from a sc dataset
and not a bulk dataset.
}
\examples{

if (requireNamespace("VariantAnnotation", quietly = TRUE) &&
    requireNamespace("preprocessCore", quietly = TRUE)) {
    bulk.means <- mockBulkMatrix(n.genes = 100, n.samples = 100)
    bulk.qnorm <- splatPopQuantNorm(newSplatPopParams(), bulk.means)
}

}
