% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/splatPop-simulate.R
\name{splatPopParseEmpirical}
\alias{splatPopParseEmpirical}
\title{splatPopParseEmpirical}
\usage{
splatPopParseEmpirical(
  vcf = vcf,
  gff = gff,
  eqtl = eqtl,
  means = means,
  params = params
)
}
\arguments{
\item{vcf}{VariantAnnotation object containing genotypes of samples.}

\item{gff}{Either NULL or a data.frame object containing a GFF/GTF file.}

\item{eqtl}{Either NULL or if simulating population parameters directly from
empirical data, a data.frame with empirical/desired eQTL results.
To see required format, run `mockEmpiricalSet()` and see eqtl output.}

\item{means}{Either NULL or if simulating population parameters directly from
empirical data, a Matrix of real gene means across a population, where
each row is a gene and each column is an individual in the population.
To see required format, run `mockEmpiricalSet()` and see means output.}

\item{params}{SplatPopParams object containing parameters for population
scale simulations. See \code{\link{SplatPopParams}} for details.}
}
\value{
A partial splatPop `key`
}
\description{
Parse splatPop key information from empirical data provided.
}
\details{
NOTE: This function will cause some of the parameters in the splatPopParams
object to be ignored, such as population level gene mean and variance and
eQTL parameters.

This function will ignore a number of parameters defined in
splatPopParams, instead pulling key information directly from provided VCF,
GFF, gene means, and eQTL mapping result data provided.
}
