% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/splat-estimate.R
\name{splatEstimate}
\alias{splatEstimate}
\alias{splatEstimate.SingleCellExperiment}
\alias{splatEstimate.matrix}
\title{Estimate Splat simulation parameters}
\usage{
splatEstimate(counts, params = newSplatParams())

\method{splatEstimate}{SingleCellExperiment}(counts, params = newSplatParams())

\method{splatEstimate}{matrix}(counts, params = newSplatParams())
}
\arguments{
\item{counts}{either a counts matrix or a SingleCellExperiment object
containing count data to estimate parameters from.}

\item{params}{SplatParams object to store estimated values in.}
}
\value{
SplatParams object with estimated values.
}
\description{
Estimate simulation parameters for the Splat simulation from a real
dataset. See the individual estimation functions for more details on how this
is done.
}
\examples{
# Load example data
library(scuttle)
set.seed(1)
sce <- mockSCE()

params <- splatEstimate(sce)
params
}
\seealso{
\code{\link{splatEstMean}},  \code{\link{splatEstLib}},
\code{\link{splatEstOutlier}}, \code{\link{splatEstBCV}},
\code{\link{splatEstDropout}}
}
