% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/splat-estimate.R
\name{splatEstOutlier}
\alias{splatEstOutlier}
\title{Estimate Splat expression outlier parameters}
\usage{
splatEstOutlier(norm.counts, params)
}
\arguments{
\item{norm.counts}{library size normalised counts matrix.}

\item{params}{SplatParams object to store estimated values in.}
}
\value{
SplatParams object with estimated values.
}
\description{
Parameters are estimated by comparing means of individual genes to the
median mean expression level.
}
\details{
Expression outlier genes are detected using the Median Absolute Deviation
(MAD) from median method. If the log2 mean expression of a gene is greater
than two MADs above the median log2 mean expression it is designated as an
outlier. The proportion of outlier genes is used to estimate the outlier
probability. Factors for each outlier gene are calculated by dividing mean
expression by the median mean expression. A log-normal distribution is then
fitted to these factors in order to estimate the outlier factor location and
scale parameters using \code{\link[fitdistrplus]{fitdist}}.
}
\keyword{internal}
