% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sparseDC-estimate.R
\name{sparseDCEstimate}
\alias{sparseDCEstimate}
\alias{sparseDCEstimate.SingleCellExperiment}
\alias{sparseDCEstimate.matrix}
\title{Estimate SparseDC simulation parameters}
\usage{
sparseDCEstimate(
  counts,
  conditions,
  nclusters,
  norm = TRUE,
  params = newSparseDCParams()
)

\method{sparseDCEstimate}{SingleCellExperiment}(
  counts,
  conditions,
  nclusters,
  norm = TRUE,
  params = newSparseDCParams()
)

\method{sparseDCEstimate}{matrix}(
  counts,
  conditions,
  nclusters,
  norm = TRUE,
  params = newSparseDCParams()
)
}
\arguments{
\item{counts}{either a counts matrix or an SingleCellExperiment object
containing count data to estimate parameters from.}

\item{conditions}{numeric vector giving the condition each cell belongs to.}

\item{nclusters}{number of cluster present in the dataset.}

\item{norm}{logical, whether to library size normalise counts before
estimation. Set this to FALSE if counts is already normalised.}

\item{params}{PhenoParams object to store estimated values in.}
}
\value{
SparseParams object containing the estimated parameters.
}
\description{
Estimate simulation parameters for the SparseDC simulation from a real
dataset.
}
\details{
The \code{nGenes} and \code{nCells} parameters are taken from the size of the
input data. The counts are preprocessed using
\code{\link[SparseDC]{pre_proc_data}} and then parameters are estimated using
\code{\link[SparseDC]{sparsedc_cluster}} using lambda values calculated using
\code{\link[SparseDC]{lambda1_calculator}} and
\code{\link[SparseDC]{lambda2_calculator}}.

See \code{\link{SparseDCParams}} for more details on the parameters.
}
\examples{
if (requireNamespace("SparseDC", quietly = TRUE)) {
    # Load example data
    library(scuttle)
    set.seed(1)
    sce <- mockSCE(ncells = 20, ngenes = 100)

    conditions <- sample(1:2, ncol(sce), replace = TRUE)

    params <- sparseDCEstimate(sce, conditions, nclusters = 3)
    params
}
}
