% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pheno-estimate.R
\name{phenoEstimate}
\alias{phenoEstimate}
\alias{phenoEstimate.SingleCellExperiment}
\alias{phenoEstimate.matrix}
\title{Estimate PhenoPath simulation parameters}
\usage{
phenoEstimate(counts, params = newPhenoParams())

\method{phenoEstimate}{SingleCellExperiment}(counts, params = newPhenoParams())

\method{phenoEstimate}{matrix}(counts, params = newPhenoParams())
}
\arguments{
\item{counts}{either a counts matrix or an SingleCellExperiment object
containing count data to estimate parameters from.}

\item{params}{PhenoParams object to store estimated values in.}
}
\value{
PhenoParams object containing the estimated parameters.
}
\description{
Estimate simulation parameters for the PhenoPath simulation from a real
dataset.
}
\details{
The \code{nGenes} and \code{nCells} parameters are taken from the size of the
input data. The total number of genes is evenly divided into the four types.
See \code{\link{PhenoParams}} for more details on the parameters.
}
\examples{
if (requireNamespace("phenopath", quietly = TRUE)) {
    # Load example data
    library(scuttle)
    set.seed(1)
    sce <- mockSCE()

    params <- phenoEstimate(sce)
    params
}
}
