% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lun-simulate.R
\name{lunSimulate}
\alias{lunSimulate}
\title{Lun simulation}
\usage{
lunSimulate(params = newLunParams(), sparsify = TRUE, verbose = TRUE, ...)
}
\arguments{
\item{params}{LunParams object containing Lun simulation parameters.}

\item{sparsify}{logical. Whether to automatically convert assays to sparse
matrices if there will be a size reduction.}

\item{verbose}{logical. Whether to print progress messages.}

\item{...}{any additional parameter settings to override what is provided in
\code{params}.}
}
\value{
SingleCellExperiment object containing the simulated counts and
intermediate values.
}
\description{
Simulate single-cell RNA-seq count data using the method described in Lun,
Bach and Marioni "Pooling across cells to normalize single-cell RNA
sequencing data with many zero counts".
}
\details{
The Lun simulation generates gene mean expression levels from a gamma
distribution with \code{shape = mean.shape} and \code{rate = mean.rate}.
Counts are then simulated from a negative binomial distribution with
\code{mu = means} and \code{size = 1 / bcv.common}. In addition each cell is
given a size factor (\code{2 ^ rnorm(nCells, mean = 0, sd = 0.5)}) and
differential expression can be simulated with fixed fold changes.

See \code{\link{LunParams}} for details of the parameters.
}
\examples{
sim <- lunSimulate()

}
\references{
Lun ATL, Bach K, Marioni JC. Pooling across cells to normalize single-cell
RNA sequencing data with many zero counts. Genome Biology (2016).

Paper: \url{dx.doi.org/10.1186/s13059-016-0947-7}

Code: \url{https://github.com/MarioniLab/Deconvolution2016}
}
