% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lun2-simulate.R
\name{lun2Simulate}
\alias{lun2Simulate}
\title{Lun2 simulation}
\usage{
lun2Simulate(
  params = newLun2Params(),
  zinb = FALSE,
  sparsify = TRUE,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{params}{Lun2Params object containing simulation parameters.}

\item{zinb}{logical. Whether to use a zero-inflated model.}

\item{sparsify}{logical. Whether to automatically convert assays to sparse
matrices if there will be a size reduction.}

\item{verbose}{logical. Whether to print progress messages.}

\item{...}{any additional parameter settings to override what is provided in
\code{params}.}
}
\value{
SingleCellExperiment containing simulated counts.
}
\description{
Simulate single-cell RNA-seq count data using the method described in Lun
and Marioni "Overcoming confounding plate effects in differential expression
analyses of single-cell RNA-seq data".
}
\details{
The Lun2 simulation uses a negative-binomial distribution where the means and
dispersions have been sampled from a real dataset
(using \code{\link{lun2Estimate}}). The other core feature of the Lun2
simulation is the addition of plate effects. Differential expression can be
added between two groups of plates (an "ingroup" and all other plates).
Library size factors are also applied and optionally a zero-inflated
negative-binomial can be used.

If the number of genes to simulate differs from the number of provided gene
parameters or the number of cells to simulate differs from the number of
library sizes the relevant parameters will be sampled with a warning. This
allows any number of genes or cells to be simulated regardless of the
number in the dataset used in the estimation step but has the downside that
some genes or cells may be simulated multiple times.
}
\examples{
sim <- lun2Simulate()
}
\references{
Lun ATL, Marioni JC. Overcoming confounding plate effects in differential
expression analyses of single-cell RNA-seq data. Biostatistics (2017).

Paper: \url{dx.doi.org/10.1093/biostatistics/kxw055}

Code: \url{https://github.com/MarioniLab/PlateEffects2016}
}
