% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kersplat-simulate.R
\name{kersplatSimLibSizes}
\alias{kersplatSimLibSizes}
\title{Simulate Kersplat library sizes}
\usage{
kersplatSimLibSizes(sim, params, verbose)
}
\arguments{
\item{sim}{SingleCellExperiment containing simulation.}

\item{params}{KersplatParams object with simulation parameters.}

\item{verbose}{logical. Whether to print progress messages}
}
\value{
SingleCellExperiment with library sizes
}
\description{
Generate library sizes for cells in the Kersplat simulation
}
\details{
Library sizes are simulated in one of two ways depending on the value of the
\code{lib.method} parameter.

If \code{lib.method} is "fit" (default) then means are sampled from a
log-normal distribution with meanlog equals \code{lib.loc} and sdlog equals
\code{lib.scale}.

If \code{mean.method} is "density" then library sizes are sampled from the
density object in the \code{lib.density} parameter using a rejection
sampling method. This approach is more flexible but may violate some
statistical assumptions.

Ambient library sizes are also generated from a log-normal distribution based
on the parameters for the cell library size and adjusted using the
\code{ambient.scale} parameter.
}
\keyword{internal}
