% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BASiCS-estimate.R
\name{BASiCSEstimate}
\alias{BASiCSEstimate}
\alias{BASiCSEstimate.SingleCellExperiment}
\alias{BASiCSEstimate.matrix}
\title{Estimate BASiCS simulation parameters}
\usage{
BASiCSEstimate(
  counts,
  spike.info = NULL,
  batch = NULL,
  n = 20000,
  thin = 10,
  burn = 5000,
  regression = TRUE,
  params = newBASiCSParams(),
  verbose = TRUE,
  progress = TRUE,
  ...
)

\method{BASiCSEstimate}{SingleCellExperiment}(
  counts,
  spike.info = NULL,
  batch = NULL,
  n = 20000,
  thin = 10,
  burn = 5000,
  regression = TRUE,
  params = newBASiCSParams(),
  verbose = TRUE,
  progress = TRUE,
  ...
)

\method{BASiCSEstimate}{matrix}(
  counts,
  spike.info = NULL,
  batch = NULL,
  n = 20000,
  thin = 10,
  burn = 5000,
  regression = TRUE,
  params = newBASiCSParams(),
  verbose = TRUE,
  progress = TRUE,
  ...
)
}
\arguments{
\item{counts}{either a counts matrix or a SingleCellExperiment object
containing count data to estimate parameters from.}

\item{spike.info}{data.frame describing spike-ins with two columns: "Name"
giving the names of the spike-in features (must match
\code{rownames(counts)}) and "Input" giving the number of input
molecules.}

\item{batch}{vector giving the batch that each cell belongs to.}

\item{n}{total number of MCMC iterations. Must be \code{>= max(4, thin)} and
a multiple of \code{thin}.}

\item{thin}{thining period for the MCMC sampler. Must be \code{>= 2}.}

\item{burn}{burn-in period for the MCMC sampler. Must be in the range
\code{1 <= burn < n} and a multiple of \code{thin}.}

\item{regression}{logical. Whether to use regression to identify
over-dispersion. See \code{\link[BASiCS]{BASiCS_MCMC}} for details.}

\item{params}{BASiCSParams object to store estimated values in.}

\item{verbose}{logical. Whether to print progress messages.}

\item{progress}{logical. Whether to print additional BASiCS progress
messages.}

\item{...}{Optional parameters passed to \code{\link[BASiCS]{BASiCS_MCMC}}.}
}
\value{
BASiCSParams object containing the estimated parameters.
}
\description{
Estimate simulation parameters for the BASiCS simulation from a real dataset.
}
\details{
This function is just a wrapper around \code{\link[BASiCS]{BASiCS_MCMC}} that
takes the output and converts it to a BASiCSParams object. Either a set of
spike-ins or batch information (or both) must be supplied. If only batch
information is provided there must be at least two batches. See
\code{\link[BASiCS]{BASiCS_MCMC}} for details.
}
\examples{
\donttest{
# Load example data
library(scuttle)
set.seed(1)
sce <- mockSCE()

spike.info <- data.frame(
    Name = rownames(sce)[1:10],
    Input = rnorm(10, 500, 200),
    stringsAsFactors = FALSE
)
params <- BASiCSEstimate(sce[1:100, 1:30], spike.info)
params
}
}
