% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compCytof.R
\name{compCytof}
\alias{compCytof}
\title{Compute spillover probability and correct for spillover}
\usage{
compCytof(
  sce,
  sce_bead,
  marker_to_barc,
  impute_value,
  overwrite = FALSE,
  n_cores = 1,
  naive = FALSE
)
}
\arguments{
\item{sce}{\code{\link[SingleCellExperiment]{SingleCellExperiment}} for the
real cells}

\item{sce_bead}{\code{\link[SingleCellExperiment]{SingleCellExperiment}} for
the bead experiment}

\item{marker_to_barc}{Table that maps the marker to the barcode
in the beads experiment}

\item{impute_value}{Imputed value for counts that are declared as spillover}

\item{overwrite}{logical; if TRUE data are overwritten if FALSE
data are saved in new columns}

\item{n_cores}{Number of computing cores}

\item{naive}{logical; if TRUE use the naive version}
}
\value{
A \code{\link[SingleCellExperiment]{SingleCellExperiment}} object
}
\description{
Compute spillover probability and correct for spillover
}
\examples{
library(CATALYST)
library(dplyr)
bc_key <- c(139, 141:156, 158:176)
sce_bead <- prepData(ss_exp)
sce_bead <- assignPrelim(sce_bead, bc_key, verbose = FALSE)
sce_bead <- applyCutoffs(estCutoffs(sce_bead))
sce_bead <- computeSpillmat(sce_bead)
data(mp_cells, package = "CATALYST")
sce <- prepData(mp_cells)
marker_to_barc <- rowData(sce_bead)[, c("channel_name", "is_bc")] |>
    as_tibble() |>
    filter(is_bc == TRUE) |>
    mutate(barcode = bc_key) |>
    select(marker = channel_name, barcode)
spillR::compCytof(sce, sce_bead, marker_to_barc, impute_value = NA)
}
