% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tile_bins.R
\name{tile_bins}
\alias{tile_bins}
\title{Tile the assembly-based contigs of a merged assembly/spike GRanges.}
\usage{
tile_bins(gr, binwidth = 300L)
}
\arguments{
\item{gr}{the GRanges}

\item{binwidth}{bin width to tile (default is 300)}
}
\value{
\if{html}{\out{<div class="sourceCode">}}\preformatted{       a GRanges of bins
}\if{html}{\out{</div>}}
}
\description{
refactored out of scan_spiked_bam for more explicit information flow
}
\examples{

bam <- system.file("extdata", "ex1.bam", package="Rsamtools",
                   mustWork=TRUE)
gr <- as(seqinfo_from_header(bam), "GRanges")
genome(gr) <- "notspike"
tile_bins(gr)


}
