% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scan_spike_bedpe.R
\name{scan_spike_bedpe}
\alias{scan_spike_bedpe}
\title{Scan spikes BEDPE}
\usage{
scan_spike_bedpe(bedpe, spike, how = "max")
}
\arguments{
\item{bedpe}{the BEDPE file path, or output from read_bedpe()}

\item{spike}{information about the spikes (default: load \code{spike})}

\item{how}{how to summarize the per-spike coverage (max)}
}
\value{
\if{html}{\out{<div class="sourceCode">}}\preformatted{     a GRanges with coverage
}\if{html}{\out{</div>}}
}
\description{
Scan spikes BEDPE
}
\examples{
data(spike, package="spiky")
fl <- system.file("extdata", "example_spike_bedpe.bed.gz", package="spiky",mustWork=TRUE)
scan_spike_bedpe(fl,spike=spike) # will warn user about spike contigs

}
