% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scan_methylation_specificity.R
\name{scan_methylation_specificity}
\alias{scan_methylation_specificity}
\title{tabulate methylation specificity for multiple spike-in BAM/CRAM files}
\usage{
scan_methylation_specificity(files, spike, sep = "_")
}
\arguments{
\item{files}{a vector of BAM/CRAM file names}

\item{spike}{a spike-in database}

\item{sep}{the separator for spike-in contig names ("_")}
}
\value{
\if{html}{\out{<div class="sourceCode">}}\preformatted{   a matrix with columns "mean" and "median"
}\if{html}{\out{</div>}}
}
\description{
Methylation specificity is here defined as methylated_spike_covg/spike_covg
}
\examples{
data(spike) 
library(GenomicRanges)
sb <- system.file("extdata", "example.spike.bam", package="spiky", 
                  mustWork=TRUE)
scan_methylation_specificity(sb, spike=spike)

}
